import { ref, inject } from 'vue'
import { useRouter } from 'vue-router'

export default function useOfferHistory() {
    var date = new Date();
    const offersHistoryList = ref({});
    const formOffersHistory = ref({
        quoteNumber:'',
        contractNumber:'',
        state: 1, 
        startDate:  ref(formatDate(new Date(date.getFullYear(), date.getMonth(), 1))),
        endDate:  ref(formatDate(new Date(date.getFullYear(), date.getMonth() + 1, 0)))
     
    })
    const router = useRouter()
    const isLoading = ref(false)
    function formatDate(date) {
        const year = date.getFullYear();
        const month = (date.getMonth() + 1).toString().padStart(2, '0');
        const day = date.getDate().toString().padStart(2, '0');
        return `${year}-${month}-${day}`;
      }
    const getOfferHistory = async (page = 1, search_global = '',search_quoteNumber = '',search_contractNumber = '',search_state = '',search_startDate = '',search_endDate = '') => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getOfferHistory?page=${page}&search_global=${search_global}&search_quoteNumber=${search_quoteNumber}&search_contractNumber=${search_contractNumber}&search_state=${search_state}&search_startDate=${search_startDate}&search_endDate=${search_endDate}`);
            offersHistoryList.value = response.data;
            // console.log(offersHistoryList.value);
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }


    return {
        formOffersHistory,
        offersHistoryList,
        getOfferHistory,
        isLoading
    }
}
