<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('VentaDetalle', function (Blueprint $table) {
            $table->string('id',64);
            $table->string('idVenta',64)->nullable();
            $table->integer('cantidad',);
            $table->string('idProductoDetalle',200)->nullable();
            $table->decimal('subTotal',8,2);
            $table->decimal('igv',8,2);
            $table->decimal('precioVenta',8,2);
            $table->decimal('descuentoProducto',8,2)->nullable();
            $table->decimal('descuentoRecurrente',8,2)->nullable();
            $table->decimal('comision',8,2)->nullable();
            $table->integer('usuarioCreador',);
            $table->datetime('fechaCreacion');
            $table->integer('usuarioModificador',)->nullable();
            $table->datetime('fechaModificacion')->nullable();
            $table->boolean('estado');
            $table->string('idTipoModalidadProducto',64)->nullable();
            $table->decimal('precioUnitario',8,2)->nullable();
            $table->decimal('descuentoAdicional',8,2)->nullable();
            $table->decimal('recurrenteSubTotal',8,2)->nullable();
            $table->decimal('precioVentaRecurrente',8,2)->nullable();
            $table->string('tipoActividad',200)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ventadetalle');
    }
};
