<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\ApiResource;
use App\Models\Btc2;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Btc2Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $distinctCodCliente = Btc2::select('nombre', 'codigoCliente')->distinct()->get();
        return ApiResource::collection($distinctCodCliente);
    }

    public function FnGetContratos(Request $request)
    {
        $codClient = $request->input('param');
        $contratos = Btc2::select('codigoCliente', 'numeroContrato', 'codigoRegimen', 'CodigoTipoPanel', 'metodoPago')
                        ->where('codigoCliente', $codClient)
                        ->get();
        
        return ApiResource::collection($contratos);
    }

    public function FnGetAllByCodRegimen($valorCondicion)
    {
        $resultados = Btc2::where('codigoRegimen', $valorCondicion)->get();

        return ApiResource::collection($resultados);
    }

    // NUEVO
    public function FnGetClientes(Request $request)
    {
        $name = $request->input('busqueda');
        $clientes = DB::select('CALL GetClienteBtcPagination(1,30,?)', [$name]);
        return $clientes;
    }

    public function FnGetContratoByNumero(Request $request)
    {
        $numeroContrato = $request->input('numeroContrato');
        $idCategoriaPerfil = $request->input('idCategoriaPerfil');
        $contratos = DB::select('CALL findByBtcByNumeroContrato(?,?,1,0)', [$numeroContrato,$idCategoriaPerfil]);
        return $contratos[0];
    }

    public function FnGetModalidades(Request $request)
    {
        $idCategoriaPerfil = $request->input('idCategoriaPerfil');
        $modalidades = DB::select('CALL CargaInicialVenta(?)', [$idCategoriaPerfil]);
        return $modalidades;
    }


    public function FnGetCampanasByCliente(Request $request)
    {
        $codCLient = $request->input('codCLient');
        $campanas = DB::select('CALL getAllCampanasXCliente(?)', [$codCLient]);
        return $campanas;
    }

    public function FnGetDetailsCampanasProduct(Request $request)
    {
        $prmCodigoCliente = $request->input('prmCodigoCliente');
        $prmIdCampana = $request->input('prmIdCampana');
        $detailsCampanasProduct = DB::select("CALL getCampanasNboCliente(?,'P',?)", [$prmCodigoCliente,$prmIdCampana]);
        return $detailsCampanasProduct;
    }

    public function FnGetDetailsCampanasService(Request $request)
    {
        $prmCodigoCliente = $request->input('prmCodigoCliente');
        $prmIdCampana = $request->input('prmIdCampana');
        $detailsCampanasService = DB::select("CALL getCampanasNboCliente(?,'S',?)", [$prmCodigoCliente,$prmIdCampana]);
        return $detailsCampanasService;
    }


   
}
