<?php

use App\Http\Controllers\Api\Btc2Controller;
use App\Http\Controllers\Api\BudgetController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\OfferHistoryController;
use App\Http\Controllers\Api\PermissionController;
use App\Http\Controllers\Api\PostController;
use App\Http\Controllers\Api\ProductoController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\RoleController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\TaskController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Api\VentaController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Auth\ForgotPasswordController;


Route::post('forget-password', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('forget.password.post');
Route::post('reset-password', [ResetPasswordController::class, 'reset'])->name('password.reset');
Route::get('getOfferHistory', [OfferHistoryController::class, 'FnGetOfferHistory']);

Route::group(['middleware' => 'auth:sanctum'], function() {
    Route::apiResource('users', UserController::class);
    Route::apiResource('posts', PostController::class);
    Route::apiResource('categories', CategoryController::class);
    Route::apiResource('roles', RoleController::class);
    Route::apiResource('btc2s', Btc2Controller::class);

    // BEGIN ENDPOINT PRODUCTS DE OFERTAS
    Route::apiResource('products', ProductoController::class);
    Route::get('getProductsSalesDetails', [ProductoController::class, 'FnGetProductsSalesDetails']);


    Route::get('getProductsNbo', [ProductoController::class, 'FnGetProductsNbo']);
    Route::get('getServiceNbo', [ProductoController::class, 'FnGetServiceNbo']);
    // END ENDPOINT PRODUCTS DE OFERTAS

    Route::get('getContratos', [Btc2Controller::class, 'FnGetContratos']);

    
    Route::get('role-list', [RoleController::class, 'getList']);
    Route::get('getAllCodRegimen/{id}', [Btc2Controller::class, 'FnGetAllByCodRegimen']);
    Route::get('role-permissions/{id}', [PermissionController::class, 'getRolePermissions']);
    Route::put('/role-permissions', [PermissionController::class, 'updateRolePermissions']);
    Route::apiResource('permissions', PermissionController::class);
    Route::get('category-list', [CategoryController::class, 'getList']);
    Route::get('/user', [ProfileController::class, 'user']);
    Route::put('/user', [ProfileController::class, 'update']);

    //NUEVO
    Route::get('getSearchProducts', [ProductoController::class, 'FnSearchProducts']);
    Route::get('getAllProductsKit', [ProductoController::class, 'FnGetAllProductsKit']);

    Route::get('getAllClientes', [Btc2Controller::class, 'FnGetClientes']);
    Route::get('getContratoByNumero', [Btc2Controller::class, 'FnGetContratoByNumero']);
    Route::get('getModalidades', [Btc2Controller::class, 'FnGetModalidades']);
    Route::get('getCampanasByCliente', [Btc2Controller::class, 'FnGetCampanasByCliente']);
    Route::get('getDetailsCampanasProduct', [Btc2Controller::class, 'FnGetDetailsCampanasProduct']);
    Route::get('getDetailsCampanasService', [Btc2Controller::class, 'FnGetDetailsCampanasService']);

    Route::get('getVentaById', [VentaController::class, 'FnGetVentaById']);
    Route::post('insertVenta', [VentaController::class, 'FnInsertVenta']);
    Route::post('insertMassiveVentaDetalle', [VentaController::class, 'FnInsertMassiveVentaDetalle']);
    Route::post('updateInsertMassiveVentaDetalle', [VentaController::class, 'FnUpdateInsertMassiveVentaDetalle']);
   


    
    // BEGIN ENDPOINT HISTORIAL DE OFERTAS
    // END ENDPOINT HISTORIAL DE OFERTAS

    Route::apiResource('tasks', TaskController::class);
    // Route::get('getTasks', [TaskController::class, 'getTasks']);
    // Route::post('storeTask', [TaskController::class, 'storeTask']);
    // Route::post('updateTask/{id}', [TaskController::class, 'updateTask']);
    // Route::post('deleteTask/{id}', [TaskController::class, 'deleteTask']);
    


    Route::get('abilities', function(Request $request) {
        return $request->user()->roles()->with('permissions')
            ->get()
            ->pluck('permissions')
            ->flatten()
            ->pluck('name')
            ->unique()
            ->values()
            ->toArray();
    });
});

Route::get('downloadbudget', [BudgetController::class, 'FngenerateReportPDF']);

Route::get('category-list', [CategoryController::class, 'getList']);
Route::get('get-posts', [PostController::class, 'getPosts']);
Route::get('get-category-posts/{id}', [PostController::class, 'getCategoryByPosts']);
Route::get('get-post/{id}', [PostController::class, 'getPost']);