import { ref, inject } from 'vue'

export default function useVentas() {

    const idVenta = ref([]);
    const vUrlReporte = ref('');
    const getVenta = ref({
        estadoVenta:0
    });

    const insertVenta = async (venta) => {
        try {
            const response = await axios.post(`${window.appUrl}/api/insertVenta`, venta);
            idVenta.value = response.data[0].GUIDID;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const insertMassiveVentaDetalle = async (ventaDetalle) => {
        try {
            const response = await axios.post(`${window.appUrl}/api/insertMassiveVentaDetalle`, ventaDetalle);
            //console.log(response.data);
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }


    const UpdateInsertMassiveVentaDetalle = async (ventaDetalle) => {
        try {
            const response = await axios.post(`${window.appUrl}/api/updateInsertMassiveVentaDetalle`, ventaDetalle);
            //console.log(response.data);
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const downloadbudget = async (parametro) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/downloadbudget?parametro=` + parametro);
            // console.log(response);
            vUrlReporte.value = response;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

  

    const FnGetVentaById = async (ventaId) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getVentaById?ventaId=` + ventaId);
            getVenta.value=response.data;
            // console.log(getVenta.value);
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    return {
        getVenta,
        FnGetVentaById,
        UpdateInsertMassiveVentaDetalle,
        insertVenta,
        insertMassiveVentaDetalle,
        downloadbudget,
        idVenta,
        vUrlReporte
    }
}