import { ref, reactive, inject } from 'vue'

export default function useProducts() {
    // const productList = ref([]);
    const productSearchList = ref([]);
    const productListKit = ref([]);
    const vProductsNbo = ref([]);
    const vProductsService = ref([]);
    const tblListProductDetail = reactive({
        tableData: [],
        vProductsNbo:[],
        vProductsService:[]
    })

    const formsProducts = ref({
        precioVenta: 0,
        codigoOracle: '',
        codigoSiebel: '',
        igv: 0,
        moneda: '',
        recurrenteSubtotal: 0,
        subTotal: 0,
        recurrentetotal: 0
    });
    const formQueryProduct = ref({
        modalidad: '',
        tipoActividad: '',
        selectedProduct: []
    });

    const toast = inject('$toast');
    /// al momento de escibir me trae el resultado
    const getSearchProducts = async (valor, queryParams) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getSearchProducts?busqueda=` + valor + `&idTipoModalidadProducto=` + queryParams.modalidad + `&tipoPanel=` + queryParams.panel + `&numeroContrato=` + queryParams.contrato);
            productSearchList.value = response.data;
            // console.log(response.data);
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getAllProductsKit = async (queryParams) => {
        try {
            // console.log(queryParams);
            const response = await axios.get(`${window.appUrl}/api/getAllProductsKit?codigoOraclePadre=` + queryParams.codigoOraclePadre + `&tipoModalidad=` + queryParams.tipoModalidad);
            productListKit.value = response.data;
            //console.log(response.data);
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getProductsById = async (id) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/products/` + id);
            formsProducts.value = response.data.data;
            // console.log(response);
            // console.log(id.toString());
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }


    const getProductsNbo = async () => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getProductsNbo`);
            // console.log(response.data);
          
            response.data.forEach(item => {
                item.quantity = 1;
                item.chkStatusNbo = false;
            });
            tblListProductDetail.vProductsNbo = response.data;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getServiceNbo = async () => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getServiceNbo`);
            // console.log(response.data);
            response.data.forEach(item => {
                item.quantity = 1;
                item.chkStatusNbo = false;
            });
            tblListProductDetail.vProductsService = response.data;
            // console.log( tblListProductDetail.vProductsService );
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }



    const getProductsDetailsByCodigo = async (codigo) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getProductsSalesDetails?numeroContrato=` + codigo);
            // console.log(response.data);
            tblListProductDetail.tableData = response.data;

        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }


    return {
        toast,
        getProductsNbo,
        vProductsNbo,
        getServiceNbo,
        vProductsService,
        getProductsDetailsByCodigo,
        tblListProductDetail,
        formsProducts,
        formQueryProduct,
        getProductsById,
        productSearchList,
        productListKit,
        getSearchProducts,
        getAllProductsKit
    }
}