<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('descuentodetalle', function (Blueprint $table) {
            $table->string('id',64);
            $table->string('idCategoriaCliente',64)->nullable();
            $table->string('idCategoriaPerfil',64);
            $table->decimal('porcentajeDescuento',8,2);
            $table->decimal('porcentajeDescuentoDeuda',8,2);
            $table->decimal('porcentajeDescuentoRobo',8,2);
            $table->integer('usuarioCreador',);
            $table->datetime('fechaCreacion');
            $table->integer('usuarioModificador',)->nullable();
            $table->datetime('fechaModificacion')->nullable();
            $table->boolean('estado');
            $table->string('idDescuento',64)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('descuentodetalle');
    }
};
