<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Producto extends Model
{
    use HasFactory;
    protected $table = 'producto';

    protected $fillable = [
        'id',
        'descripcionTipoProducto',
        'codigoSiebel',
        'descripcionSiebel',
        'codigoOracle',
        'descripcionOracle',
        'codigoGsmart',
        'recurrenteSubtotal',
        'recurrenteTotal',
        'usuarioCreador',
        'fechaCreacion',
        'usuarioModificador',
        'fechaModificacion',
        'estado',
        'tipoPanel',
        'flagProductoEspecial',
        'marca',
        'recurrenteHogar',
        'recurrenteNegocio',
        'esRecurrenteHogarNegocio',
    ];

    protected $casts = [
        'recurrenteSubtotal' => 'decimal:2',
        'recurrenteTotal' => 'decimal:2',
        'recurrenteHogar' => 'decimal:2',
        'recurrenteNegocio' => 'decimal:2',
        'esRecurrenteHogarNegocio' => 'boolean',
        'flagProductoEspecial' => 'boolean',
    ];

}
