<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Btc2 extends Model
{
    use HasFactory;
    protected $table = 'btc2';

    protected $appends = ['Fullname'];

    protected $fillable = [
        'id',
        'numeroContrato',
        'codigoCliente',
        'codigoConexion',
        'nifCliente',
        'nombre',
        'codigoTipoContrato',
        'respaldo',
        'normativaContrato',
        'codigoRegimen',
        'fechaInstalacion',
        'fechaVencimiento',
        'codigoEstado',
        'clasificacionComercial',
        'Churn_Rate_Clas_Com',
        'metodoPago',
        'segmentoCliente',
        'responsableCliente',
        'codigoActividadInmueble',
        'codigoSubtipoLocal',
        'paqueteComercial',
        'CodigoTipoPanel',
        'telfDireccionInstalacion',
        'direccionInstalacion',
        'localidadDirInstalacion',
        'provinciaDirInstalacion',
        'regionDirInstalacion',
        'codigoPostalDirInstalacion',
        'delegacionAdministrativa',
        'correoCliente',
        'emailNotificacion',
        'motivoBaja',
        'fechaBaja',
        'totalRecurrente',
        'usuarioCreador',
        'fechaCreacion',
        'TipoPanel',
    ];
    
  public function getFullnameAttribute()
    {
        return "{$this->codigoCliente} {$this->nombre}";
    }
    

}
