<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\ApiResource;
use App\Http\Resources\ProductoResource;
use App\Models\Producto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $producto = Producto::all();
        return ApiResource::collection($producto);
    }

    // NUEVO
    public function FnSearchProducts(Request $request)
    {
        $busqueda = $request->input('busqueda');
        $idTipoModalidadProducto = $request->input('idTipoModalidadProducto');
        $tipoPanel = $request->input('tipoPanel');
        $numeroContrato = $request->input('numeroContrato');
        $products = DB::select('CALL GetSelectProductosPagination2(1,30,?,?,?,?)', [$busqueda, $idTipoModalidadProducto, $tipoPanel, $numeroContrato]);
        return $products;
    }

    public function FnGetAllProductsKit(Request $request)
    {
        $codigoOraclePadre = $request->input('codigoOraclePadre');
        $tipoModalidad = $request->input('tipoModalidad');
        $products = DB::select('CALL GetProductosKit(?,?)', [$codigoOraclePadre, $tipoModalidad]);
        return $products;
    }

    public function FnGetProductsSalesDetails(Request $request)
    {
        $numeroContrato = $request->input('numeroContrato');
        $contratos = DB::select('CALL GetInfoProductsDetalle(?)', [$numeroContrato]);
        return $contratos;
    }


    // ////////////////////////////////////

    public function FnGetProductsNbo(Request $request)
    {
     
    $registros = Producto::skip(1)->take(2)->get();
    return $registros;
    }


    public function FnGetServiceNbo(Request $request)
    {
        $registros = Producto::orderBy('created_at', 'desc')->take(2)->get();
        return $registros;
    }


    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $producto = DB::select('CALL sp_get_producto_por_id(?)', [$id]);
        if (empty($producto)) {
            return response()->json(['message' => 'Producto no encontrado'], 404);
        }
        $producto = $producto[0];

        return new ProductoResource($producto);
    }
}
