<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\ApiResource;
use App\Models\Btc2;
use App\Models\Category;
use App\Models\Producto;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\DB;

class OfferHistoryController extends Controller
{

   
    public function FnGetOfferHistory()
    {
        $searchTerm = request('search_global');
        $searchQuoteNumber = request('search_quoteNumber');
        $searchContractNumber = request('search_contractNumber');
        $searchState = request('search_state');
        $startDate = request('search_startDate');
        $endDate = request('search_endDate');
        
        $result = DB::select('CALL GetOfferHistory(?,?,?, ?, ?, ?)', [
            $searchTerm,
            $searchQuoteNumber,
            $searchContractNumber,
            $searchState,
            $startDate,
            $endDate
        ]);
    
        $resultArray = json_decode(json_encode($result), true);

        $page = request('page', 1);
        $perPage = 5; 
        $offSet = ($page * $perPage) - $perPage;
        $itemsForCurrentPage = array_slice($resultArray, $offSet, $perPage, true);
        
        $paginatedData = new LengthAwarePaginator($itemsForCurrentPage, count($resultArray), $perPage, $page);

        return ApiResource::collection($paginatedData);
    }
    
}
